# This script is used to extract the unique parameter combinations from the DE output

# Remove all variables
rm(list=ls(all = TRUE))
# Clear the console window
cat("\014")

library("mgcv")
library("ggplot2")

# ------------------------------------------------------------------------------
# C only
# ------------------------------------------------------------------------------

# The output file is loaded
folder <- "GA output/"

filename = paste(folder, "DE_out.RData", sep = "")
load(file = filename)
rm(filename)

# The number of iterations is obtained
n <- length(outDE$member$storepop)

# The error is plotted in function of iteration number
df_error <- data.frame("iteration" = 1:(n+1),
                    "error" = outDE$member$bestvalit)

ggplot(df_error, aes(x = iteration, y = error)) +
  geom_line()

# All parameter combinations are retrieved, after the lowest error has been obtained
# paramCombi <- NA

nStart <- 1
for(ii in nStart:n){

  if(ii == nStart){
    paramCombi <- outDE$member$storepop[[ii]]
  } else{
    paramCombi <- rbind(paramCombi,outDE$member$storepop[[ii]])
  }
}

# Only unique rows with parameter values are retained
uniqueParam <- uniquecombs(paramCombi)

# These parameter values are saved
save(uniqueParam, file = "GA output/.RData")

# ------------------------------------------------------------------------------
# C, d13C and d14C
# ------------------------------------------------------------------------------

# Remove all variables
rm(list=ls(all = TRUE))
# Clear the console window
cat("\014")

# The output file is loaded
folder <- "GA output/"

filename = paste(folder, "DE_out.RData", sep = "")
load(file = filename)
rm(filename)

# The number of iterations is obtained
n <- length(outDE$member$storepop)

# The error is plotted in function of iteration number
df_error <- data.frame("iteration" = 1:(n+1),
                       "error" = outDE$member$bestvalit)

ggplot(df_error, aes(x = iteration, y = error)) +
  geom_line()

# All parameter combinations are retrieved, after the lowest error has been obtained
# paramCombi <- NA

nStart <- 1
for(ii in nStart:n){
  
  if(ii == nStart){
    paramCombi <- outDE$member$storepop[[ii]]
  } else{
    paramCombi <- rbind(paramCombi,outDE$member$storepop[[ii]])
  }
}

# Only unique rows with parameter values are retained
uniqueParam <- uniquecombs(paramCombi)

# These parameter values are saved
# save(uniqueParam, file = "GA output/.RData")

# ------------------------------------------------------------------------------
# C and d13C
# ------------------------------------------------------------------------------

# Remove all variables
rm(list=ls(all = TRUE))
# Clear the console window
cat("\014")

# The output file is loaded
# folder <- "GA output/Hainich/To_50cm_depth/C_d13C/soil/"
folder <- "GA output/"

filename = paste(folder, "DE_out.RData", sep = "")
load(file = filename)
rm(filename)

# The number of iterations is obtained
n <- length(outDE$member$storepop)

# The error is plotted in function of iteration number
df_error <- data.frame("iteration" = 1:(n+1),
                       "error" = outDE$member$bestvalit)

ggplot(df_error, aes(x = iteration, y = error)) +
  geom_line()

# All parameter combinations are retrieved, after the lowest error has been obtained
# paramCombi <- NA

nStart <- 1
for(ii in nStart:n){
  
  if(ii == nStart){
    paramCombi <- outDE$member$storepop[[ii]]
  } else{
    paramCombi <- rbind(paramCombi,outDE$member$storepop[[ii]])
  }
}

# Only unique rows with parameter values are retained
uniqueParam <- uniquecombs(paramCombi)

# These parameter values are saved
# save(uniqueParam, file = "GA output/.RData")

# ------------------------------------------------------------------------------
# C and d14C
# ------------------------------------------------------------------------------

# Remove all variables
rm(list=ls(all = TRUE))
# Clear the console window
cat("\014")

# The output file is loaded
folder <- "GA output/"

filename = paste(folder, "DE_out.RData", sep = "")
load(file = filename)
rm(filename)

# The number of iterations is obtained
n <- length(outDE$member$storepop)

# The error is plotted in function of iteration number
df_error <- data.frame("iteration" = 1:(n+1),
                       "error" = outDE$member$bestvalit)

ggplot(df_error, aes(x = iteration, y = error)) +
  geom_line()

# All parameter combinations are retrieved, after the lowest error has been obtained
# paramCombi <- NA

nStart <- 175
for(ii in nStart:n){
  
  if(ii == nStart){
    paramCombi <- outDE$member$storepop[[ii]]
  } else{
    paramCombi <- rbind(paramCombi,outDE$member$storepop[[ii]])
  }
}

# Only unique rows with parameter values are retained
uniqueParam <- uniquecombs(paramCombi)

# These parameter values are saved
# save(uniqueParam, file = "GA output/.RData")
